#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009-2010 Yukikaze
import time
import os.path
import ConfigParser
import sys
import commands
import configwriter
import shutil

import recdblist
def printutf8(str):
    print str.encode('utf-8')
def install():
    version = recdblist.version
    recdblist.printutf8(u"rec10の環境インストールを開始します。")
    time.sleep(1)
    recdblist.printutf8(u"環境インストール処理中・・・")
    path = str(os.path.dirname(os.path.abspath(__file__)))
    confp = ConfigParser.SafeConfigParser()
    Conf = 'rec10.conf'
    confpath=""
    if os.path.exists(os.path.join(path,Conf)):
        confpath=os.path.join(path,Conf)
    elif os.path.exists(os.path.join("/etc","rec10.conf")):
        confpath=os.path.join("/etc","rec10.conf")
    elif os.path.exists(os.path.join("/etc/rec10","rec10.conf")):
        confpath=os.path.join("/etc/rec10","rec10.conf")
    if confpath!="":
        confp.read(confpath)
    else:
        recdblist.printutf8(u"rec10.confが見つかりません。")
        recdblist.printutf8(u"このinstall.pyと同じフォルダに置くか、/etc/rec10.confもしくは/etc/rec10/rec10.confにおいてください。")
        sys.exit(1)
    recdblist.printutf8(u"設定ファイルの読み込みを確認//設定ファイルのパスは"+confpath)
    if confp.get('path',"recpath")=="/path of /recording":
        recdblist.printutf8(u"録画先のフォルダを設定してください(recpath=)")
        sys.exit(1)
    recdblist.printutf8(u"DB処理に入ります")
    if os.path.exists(os.path.join(path,"rec10d.py")):
        try:
            update_db_all()
        except Exception, inst:
            recdblist.printutf8(u"DB処理中にエラーが出ました。configファイルのDB設定を見直してください。")
            recdblist.printutf8(str(type(inst)))
            recdblist.printutf8(str(inst))
    recdblist.printutf8(u"チャンネル設定に入ります")
    if os.path.exists(os.path.join(path,"chlist.xml")):
        recdblist.printutf8(u"チャンネルリストが見つかりました。||chlist.xml")
    else:
        recdblist.printutf8(u"チャンネルリストが見つかりません。"+os.path.join(path,"chlist.xml")+u"を作成してください。")
        recdblist.printutf8(u"東京/名古屋/神戸のサンプルがchlist_sample_*.xmlにあるため、参考にしてください。")
        sys.exit(1)
    bsok=int(confp.get('env',"bs"))
    csok=int(confp.get('env',"cs"))
    import chdata
    chdata.new_chdata(bsok,csok)
    recdblist.printutf8(u"おめでとうございます　初期設定は完了しました。")
    recdblist.printutf8(u"rec10を実行するユーザーのcrontabに"+os.path.join(path,"rec10")+u"を追加してください(5分周期が目安)")
    import rec10d
    rec10d.rec10db.change_installed_in_status()
def getpath(cmd):
    printutf8(cmd+u"の場所を確認中")
    txt=commands.getoutput(u"which "+cmd)
    if len(txt.split(" "))>3:
        printutf8(cmd+u"の場所を確認できませんでした。終了します")
        sys.exit(1)
    else:
        printutf8(cmd+u" : "+txt)
        if len(txt.splitlines()):
            txt=txt.splitlines()[0]
        return txt.strip()
def move():
    useB=0
    path = str(os.path.dirname(os.path.abspath(__file__)))
    printutf8(u"rec10 ver "+recdblist.version_str+" installer.")
    printutf8(u"rec10のインストールを開始します。")
    maxn=14
    configwriter.setpath(u"wine", getpath(u"wine"))
    configwriter.setpath(u"recpt1", getpath(u"recpt1"))
    configwriter.setpath(u"x264", getpath(u"x264"))
    configwriter.setpath(u"mp4box", getpath(u"MP4Box"))
    configwriter.setpath(u"mencoder", getpath(u"mencoder"))
    configwriter.setpath(u"ffmpeg", getpath(u"ffmpeg"))
    configwriter.setpath(u"mkvmerge", getpath(u"mkvmerge"))
    configwriter.setpath(u"b25", getpath(u"b25"))
    printutf8(u"必須環境の設定が完了しました")
    printutf8(u"個人設定に入ります")
    if os.path.exists("/etc/rec10.conf"):
        printutf8(u"以前の設定ファイルが見つかりました。")
        printutf8(u"インポートしますか？")
        useB=raw_input("[Y/n]:")
        if useB=="N" or useB == "n":
            useB=0
        else:
            useB=1
            printutf8(u"設定ファイルのインポートを行います。")
    printutf8(u"rec10の録画ファイルが置かれる場所を入力してください(1/"+str(maxn)+")")
    printutf8(u"100GB程度は確保されている必要があります")
    recpath=getConf(useB,"/etc/rec10.conf","path","recpath","path : ")
    configwriter.setpath(u"recpath",recpath)
    printutf8(u"DBの設定に入ります。")
    printutf8(u"rec10が使用するMySQLのユーザーを設定してください。(2/"+str(maxn)+")")
    mysql_user=getConf(useB,"/etc/rec10.conf","db","mysql_user","mysql_user : ")
    configwriter.setdbpath("mysql_user", mysql_user)
    printutf8(u"パスワードを設定してください(3/"+str(maxn)+")")
    mysql_passwd=getConf(useB,"/etc/rec10.conf","db","mysql_passwd","mysql_passwd : ")
    configwriter.setdbpath("mysql_passwd", mysql_passwd)
    printutf8(u"同時録画可能数の設定に入ります")
    printutf8(u"TE(地デジ)録画可能数(PT*だと2 白Friioだと1)(4/"+str(maxn)+")")
    te_max=str(int(getConf(useB,"/etc/rec10.conf","env","te_max","te_max : ")))
    configwriter.setenv("te_max", te_max)
    printutf8(u"BS/CS110録画可能数(PT*だと2 黒Friioだと1)(5/"+str(maxn)+")")
    bscs_max=str(int(getConf(useB,"/etc/rec10.conf","env","bscs_max","bscs_max : ")))
    configwriter.setenv("bscs_max", bscs_max)
    printutf8(u"同時エンコード最大数を設定してください(6/"+str(maxn)+")")
    printutf8(u"CPUのコア数が目安です")
    enc_max=raw_input("[2]:")
    if enc_max=="":
        enc_max="2"
    else:
        enc_max=str(int(enc_max))
    configwriter.setenv("enc_max", enc_max)
    printutf8(u"二カ国語放送/5.1ch放送の音声変換の設定です。\nNeroAACエンコーダーを使用しますか?(NeroAACEncを別途入手してtstoolsに入れてください。))")
    printutf8(u"入手先:http://www.nero.com/jpn/technologies-aac-codec.html\n (7/"+str(maxn)+")")
    audioenc=raw_input("[y/N]:  ")
    if audioenc=="y" or audioenc=="Y":
        configwriter.setpath("useNeroAAC", "1")
        printutf8(u"NeroAACEncのパスを指定してください")
        aacpath=getConf(useB,"/etc/rec10.conf","path","NeroAAC","[/usr/local/bin/neroAacEnc] : ")
        if aacpath.replace(" ","")=="":
            aacpath="/usr/local/bin/neroAacEnc"
        configwriter.setpath("NeroAAC",aacpath)
    else:
        configwriter.setpath("useNeroAAC", "0")
        printutf8(u"lameを使用します。")
    printutf8(u"保存する画質を教えてください(7/"+str(maxn)+")")
    printutf8(u"x264のcrfの値です。標準だと30分で800MBほどになります")
    crf=getConf(useB,"/etc/rec10.conf","env","crf","[24] : ")
    if crf.replace(" ","")=="":
        crf="24"
    configwriter.setenv("crf", crf)
    printutf8(u"アニメーションを保存する画質を教えてください(8/"+str(maxn)+")")
    printutf8(u"x264のcrfの値です。標準だと30分で800MBほどになります")
    a_crf=getConf(useB,"/etc/rec10.conf","env","animation_crf","[20] : ")
    if a_crf.replace(" ","")=="":
        a_crf="20"
    configwriter.setenv("animation_crf", a_crf)
    printutf8(u"x264の圧縮率を設定してください(8/"+str(maxn)+")")
    printutf8(u"x264のpresetの値です。標準だとmedium、小さければ小さいほど高圧縮になります")
    preset=getConf(useB,"/etc/rec10.conf","env","x264_preset","[4] : ")
    if preset.replace(" ","")=="":
        preset="4"
    configwriter.setenv("x264_preset", preset)
    printutf8(u"保存するコンテナの設定(9/"+str(maxn)+")")
    printutf8(u"MP4を標準にしますか(もしくはMKVが使えます)")
    useMP4=raw_input("[y/N]:")
    if useMP4=="Y" or useMP4 == "y" :
        useMP4="1"
    else:
        useMP4="0"
    configwriter.setenv("make_mp4", useMP4)
    printutf8(u"TSファイルの自動削除(10/"+str(maxn)+")")
    printutf8(u"中間体のtsファイルを削除しますか")
    printutf8(u"(削除するとやり直しができないため残しておくことを推奨します。)")
    removeTS=raw_input("[y/N]:")
    if removeTS=="Y" or removeTS == "y" :
        removeTS="1"
    else:
        removeTS="0"
    configwriter.setenv("remove_ts", removeTS)
    printutf8(u"チャンネルの設定に入ります(11/"+str(maxn)+")")
    printutf8(u"rec10を設置する地域を選んでください。")
    printutf8(u"1:東京 2:神戸 3:名古屋 4:その他")
    ch=raw_input()
    ch=int(ch)
    if ch==1:
        try:
            shutil.copy(os.path.join(path,"chlist_sample_tokyo.xml"),os.path.join(path,"chlist.xml"))
        except:
            printutf8(u"既存のchlis.xmlを上書きできないため、前のものを使います。")
    elif ch==2:
        try:
            shutil.copy(os.path.join(path,"chlist_sample_kobe.xml"),os.path.join(path,"chlist.xml"))
        except:
            printutf8(u"既存のchlis.xmlを上書きできないため、前のものを使います。")
    elif ch==3:
        try:
            shutil.copy(os.path.join(path,"chlist_sample_nagoya.xml"),os.path.join(path,"chlist.xml"))
        except:
            printutf8(u"既存のchlis.xmlを上書きできないため、前のものを使います。")
    elif ch==4:
        if not os.path.exists(os.path.join(path,"chlist.xml")):
            printutf8(u"チャンネルの設定が必要です。")
            printutf8(u"chlist_sample_*を参考にchlist.xmlを作成した後に次のステップに進んでください。")
            time.sleep(5)
    printutf8(u"BS放送は受信可能ですか？(12/"+str(maxn)+")")
    bsok=raw_input("y/N:")
    if bsok=="Y" or bsok == "y" :
        bsok="1"
    else:
        bsok="0"
    configwriter.setenv("bs", bsok)
    printutf8(u"CS放送(スカパーe2)は受信可能ですか？(13/"+str(maxn)+")")
    csok=raw_input("y/N:")
    if csok=="Y" or csok == "y" :
        csok="1"
        printutf8(u"標準パックの番組は入力してありますがそれ以外は追加でchlist_cs.xmlに追加する必要があります。")
    else:
        csok="0"
    configwriter.setenv("cs", csok)

    printutf8(u"自機識別オプション(14/"+str(maxn)+")")
    printutf8(u"本rec10の識別名を入力してください")
    printutf8(u"複数台のrec10を運用する場合に効果的です。空白でもかまいません。")
    printutf8(u"例 kobe01")
    iff=getConf(useB,"/etc/rec10.conf","env","iff","[] : ")
    configwriter.setenv("iff", iff)
    confp = ConfigParser.SafeConfigParser()
    confp.read("/etc/rec10.conf")
    if useB:
        configwriter.setpath("recorded",confp.get("path","recorded"))
        configwriter.setpath("move_destpath",confp.get("path","move_destpath"))
        configwriter.setpath("tmp",confp.get("path","tmp"))
        try:
            configwriter.setenv("x264_addline",confp.get("env","x264_addline"))
        except:
            configwriter.setenv("x264_addline","")
        if confp.get("path","b25_remote")=="":
            configwriter.setpath("b25_remote", "0")
        elif confp.get("path","b25_remote")=="1":
            configwriter.setpath("b25_remote", confp.get("path","b25_remote"))
            configwriter.setpath("b25", confp.get("path","b25"))
            configwriter.setpath("b25_env", confp.get("path","b25_env"))
        else:
            configwriter.setpath("b25_remote", confp.get("path","b25_remote"))

    configwriter.writeconf()
    printutf8(u"初期設定が終了しました。")
    printutf8(u"makeを実行した後にrootにてmake installを実行するとインストールされます。")
def getConf(useBeforeConf,Confpath,dbsection,key,defaultstr):
    tstr=defaultstr
    if os.path.exists(Confpath) and useBeforeConf==1:
        try:
            confp = ConfigParser.SafeConfigParser()
            confp.read("/etc/rec10.conf")
            tstr=u"["+confp.get(dbsection,key)+u"]:"
        except:
            tstr=defaultstr
    tmpconf=raw_input(tstr)
    if tmpconf.replace(" ","")=="" and os.path.exists(Confpath) and useBeforeConf==1 :
        confp = ConfigParser.SafeConfigParser()
        confp.read("/etc/rec10.conf")
        try:
            tmpconf=confp.get(dbsection,key)
        except:
            tmpconf=""
    return tmpconf
def update_db_all():
    import rec10d
    tversion=0
    if rec10d.rec10db.select_installed_in_status()==1:
        if rec10d.rec10db.select_version_in_status()==0:
            tversion=0
            recdblist.printutf8(u"既存のDBが見つかりました。0.9.1と仮定してアップデート処理を行います。")
            update_db(0)
            time.sleep(1)
        else:
            recdblist.printutf8(u"既存のDBが見つかりました。アップデート処理を行います。")
        tversion=int(rec10d.rec10db.select_version_in_status())
        while (recdblist.version>tversion):
            update_db(tversion)
            tversion=int(rec10d.rec10db.select_version_in_status())
    else:
        rec10d.rec10db.drop_in_status()
        rec10d.rec10db.drop_in_settings()
        time.sleep(2)
        rec10d.rec10db.new_in_status()
        rec10d.rec10db.new_in_settings()
        rec10d.rec10db.change_version_in_status(recdblist.version)
def update_db(version):
    import rec10d
    if version==0:
        rec10d.rec10db.update_db_to93()
    elif version==93:
        rec10d.rec10db.update_db_93to94()
    elif version==94:
        rec10d.rec10db.update_db_94to95()
    elif version==95:
        rec10d.rec10db.update_db_95to96()
if __name__ == "__main__":
    move()
